@extends('layouts.app')

@section('content')
<!-- Hero Section -->
<div class="bg-black text-white">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-20">
        <div class="text-center">
            <h1 class="text-4xl md:text-6xl font-bold mb-4">
                Buy & Sell Within Your <span class="text-yellow-400">Campus</span>
            </h1>
            <p class="text-xl text-gray-400 mb-8">
                The easiest way to find student deals. Buy, sell, and trade with fellow students.
            </p>
            @auth
                <a href="{{ route('products.create') }}" class="bg-yellow-400 text-black px-8 py-3 rounded-lg text-lg font-semibold hover:bg-yellow-300">
                    Post Item
                </a>
            @else
                <a href="{{ route('register') }}" class="bg-yellow-400 text-black px-8 py-3 rounded-lg text-lg font-semibold hover:bg-yellow-300">
                    Get Started
                </a>
            @endauth
        </div>
    </div>
</div>

<!-- Categories Section -->
<div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-12">
    <h2 class="text-2xl font-bold mb-6">Browse Categories</h2>
    <div class="grid grid-cols-2 md:grid-cols-4 lg:grid-cols-6 gap-4">
        @foreach($categories as $category)
            <a href="{{ route('categories.show', $category) }}" 
               class="bg-white p-6 rounded-lg shadow-md hover:shadow-lg transition text-center border border-gray-200">
                <div class="text-3xl mb-2">
                    @switch($category->name)
                        @case('Electronics')📱@break
                        @case('Books')📚@break
                        @case('Furniture')🪑@break
                        @case('Clothing')👕@break
                        @case('Sports')⚽@break
                        @case('Food')🍔@break
                        @default📦
                    @endswitch
                </div>
                <h3 class="font-semibold">{{ $category->name }}</h3>
                <p class="text-sm text-gray-500">{{ $category->products_count }} items</p>
            </a>
        @endforeach
    </div>
</div>

<!-- Latest Listings Section -->
<div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-12">
    <div class="flex justify-between items-center mb-6">
        <h2 class="text-2xl font-bold">Latest Listings</h2>
        <a href="{{ route('products.index') }}" class="text-yellow-400 hover:text-yellow-300">View All →</a>
    </div>
    
    @if($products->isEmpty())
        <div class="text-center py-12">
            <p class="text-gray-500 text-lg">No listings yet. Be the first to post!</p>
            @auth
                <a href="{{ route('products.create') }}" class="inline-block mt-4 bg-yellow-400 text-black px-6 py-2 rounded-lg hover:bg-yellow-300">
                    Post an Item
                </a>
            @else
                <a href="{{ route('register') }}" class="inline-block mt-4 bg-yellow-400 text-black px-6 py-2 rounded-lg hover:bg-yellow-300">
                    Sign Up to Post
                </a>
            @endauth
        </div>
    @else
        <div class="grid grid-cols-1 sm:grid-cols-2 md:grid-cols-3 lg:grid-cols-4 gap-6">
            @foreach($products as $product)
                @include('components.product-card', ['product' => $product])
            @endforeach
        </div>
    @endif
</div>

<!-- CTA Section -->
<div class="bg-gray-100">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-16">
        <div class="text-center">
            <h2 class="text-3xl font-bold mb-4">Have Something to Sell?</h2>
            <p class="text-gray-600 mb-8">Post your item in minutes and reach thousands of students on campus.</p>
            @auth
                <a href="{{ route('products.create') }}" class="bg-black text-white px-8 py-3 rounded-lg text-lg font-semibold hover:bg-gray-800">
                    Post Now
                </a>
            @else
                <a href="{{ route('register') }}" class="bg-black text-white px-8 py-3 rounded-lg text-lg font-semibold hover:bg-gray-800">
                    Create Account
                </a>
            @endauth
        </div>
    </div>
</div>
@endsection
