@extends('layouts.app')

@section('content')
<div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-8">
    <div class="flex justify-between items-center mb-8">
        <h1 class="text-3xl font-bold">My Listings</h1>
        <a href="{{ route('products.create') }}" class="bg-yellow-400 text-black px-6 py-3 rounded-lg font-semibold hover:bg-yellow-300">
            Post New Item
        </a>
    </div>

    @if($products->isEmpty())
        <div class="text-center py-12 bg-white rounded-lg">
            <p class="text-gray-500 text-lg">You haven't posted any items yet.</p>
            <a href="{{ route('products.create') }}" class="inline-block mt-4 bg-yellow-400 text-black px-6 py-2 rounded-lg hover:bg-yellow-300">
                Post Your First Item
            </a>
        </div>
    @else
        <div class="grid grid-cols-1 sm:grid-cols-2 md:grid-cols-3 lg:grid-cols-4 gap-6">
            @foreach($products as $product)
                @include('components.product-card', ['product' => $product])
            @endforeach
        </div>
        
        <div class="mt-8">
            {{ $products->links() }}
        </div>
    @endif
</div>
@endsection
