@extends('layouts.app')

@section('content')
<div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-8">
    <div class="flex flex-col md:flex-row justify-between items-start md:items-center mb-8 gap-4">
        <h1 class="text-3xl font-bold">All Listings</h1>
        
        <form action="{{ route('products.index') }}" method="GET" class="flex flex-col md:flex-row gap-4 w-full md:w-auto">
            <input type="text" name="search" value="{{ request('search') }}" placeholder="Search products..." 
                   class="px-4 py-2 border border-gray-300 rounded-lg focus:outline-none focus:border-yellow-400">
            <select name="category" class="px-4 py-2 border border-gray-300 rounded-lg focus:outline-none focus:border-yellow-400">
                <option value="">All Categories</option>
                @foreach($categories as $category)
                    <option value="{{ $category->id }}" {{ request('category') == $category->id ? 'selected' : '' }}>
                        {{ $category->name }}
                    </option>
                @endforeach
            </select>
            <button type="submit" class="bg-black text-white px-6 py-2 rounded-lg hover:bg-gray-800">
                Filter
            </button>
        </form>
    </div>

    @if($products->isEmpty())
        <div class="text-center py-12 bg-white rounded-lg">
            <p class="text-gray-500 text-lg">No products found.</p>
            @auth
                <a href="{{ route('products.create') }}" class="inline-block mt-4 bg-yellow-400 text-black px-6 py-2 rounded-lg hover:bg-yellow-300">
                    Post an Item
                </a>
            @else
                <a href="{{ route('register') }}" class="inline-block mt-4 bg-yellow-400 text-black px-6 py-2 rounded-lg hover:bg-yellow-300">
                    Sign Up to Post
                </a>
            @endauth
        </div>
    @else
        <div class="grid grid-cols-1 sm:grid-cols-2 md:grid-cols-3 lg:grid-cols-4 gap-6">
            @foreach($products as $product)
                @include('components.product-card', ['product' => $product])
            @endforeach
        </div>
        
        <div class="mt-8">
            {{ $products->links() }}
        </div>
    @endif
</div>
@endsection
