<header class="bg-black text-white">
    <nav class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="flex justify-between h-16 items-center">
            <div class="flex items-center">
                <a href="{{ route('home') }}" class="text-2xl font-bold text-yellow-400">
                    DOUPlug
                </a>
                <div class="hidden md:flex ml-10 space-x-8">
                    <a href="{{ route('home') }}" class="{{ request()->routeIs('home') ? 'text-yellow-400' : 'text-gray-300 hover:text-white' }}">Home</a>
                    <a href="{{ route('categories.index') }}" class="{{ request()->routeIs('categories.*') ? 'text-yellow-400' : 'text-gray-300 hover:text-white' }}">Categories</a>
                    @auth
                        <a href="{{ route('products.my-listings') }}" class="{{ request()->routeIs('products.my-listings') ? 'text-yellow-400' : 'text-gray-300 hover:text-white' }}">My Listings</a>
                        <a href="{{ route('messages.index') }}" class="{{ request()->routeIs('messages.*') ? 'text-yellow-400' : 'text-gray-300 hover:text-white' }}">Messages</a>
                    @endauth
                </div>
            </div>

            <div class="flex items-center space-x-4">
                <form action="{{ route('products.index') }}" method="GET" class="hidden md:flex">
                    <input type="text" name="search" placeholder="Search products..." 
                           class="px-4 py-2 rounded-lg bg-gray-800 text-white border border-gray-700 focus:outline-none focus:border-yellow-400">
                </form>

                @auth
                    @if(Auth::user()->is_admin)
                        <a href="{{ route('admin.dashboard') }}" class="text-gray-300 hover:text-white">Admin</a>
                    @endif
                    
                    <div class="relative">
                        <button onclick="toggleDropdown()" class="flex items-center space-x-2 text-gray-300 hover:text-white">
                            @if(Auth::user()->avatar)
                                <img src="{{ Storage::url(Auth::user()->avatar) }}" alt="Avatar" class="w-8 h-8 rounded-full object-cover">
                            @else
                                <div class="w-8 h-8 rounded-full bg-yellow-400 flex items-center justify-center text-black font-bold">
                                    {{ substr(Auth::user()->name, 0, 1) }}
                                </div>
                            @endif
                            <span>{{ Auth::user()->name }}</span>
                        </button>
                        <div id="dropdown" class="hidden absolute right-0 mt-2 w-48 bg-gray-800 rounded-lg shadow-lg py-2 z-50">
                            <a href="{{ route('profile.show') }}" class="block px-4 py-2 text-gray-300 hover:bg-gray-700">Profile</a>
                            <a href="{{ route('products.my-listings') }}" class="block px-4 py-2 text-gray-300 hover:bg-gray-700">My Listings</a>
                            <form method="POST" action="{{ route('logout') }}">
                                @csrf
                                <button type="submit" class="block w-full text-left px-4 py-2 text-gray-300 hover:bg-gray-700">Logout</button>
                            </form>
                        </div>
                    </div>
                @else
                    <a href="{{ route('login') }}" class="text-gray-300 hover:text-white">Login</a>
                    <a href="{{ route('register') }}" class="bg-yellow-400 text-black px-4 py-2 rounded-lg hover:bg-yellow-300">Register</a>
                @endauth
            </div>
        </div>
    </nav>
</header>

<script>
    function toggleDropdown() {
        const dropdown = document.getElementById('dropdown');
        dropdown.classList.toggle('hidden');
    }

    document.addEventListener('click', function(event) {
        const dropdown = document.getElementById('dropdown');
        const button = event.target.closest('button');
        if (!button || !button.contains(event.target)) {
            dropdown.classList.add('hidden');
        }
    });
</script>
