<div class="bg-white rounded-lg shadow-md overflow-hidden hover:shadow-lg transition">
    <a href="{{ route('products.show', $product) }}">
        @if($product->images && count($product->images) > 0)
            <img src="{{ Storage::url($product->images[0]) }}" alt="{{ $product->title }}" class="w-full h-48 object-cover">
        @else
            <div class="w-full h-48 bg-gray-200 flex items-center justify-center">
                <span class="text-4xl">📦</span>
            </div>
        @endif
    </a>
    <div class="p-4">
        <div class="flex justify-between items-start mb-2">
            <a href="{{ route('products.show', $product) }}" class="font-semibold text-lg hover:text-yellow-400 truncate">
                {{ $product->title }}
            </a>
            @if($product->status === 'sold')
                <span class="bg-red-100 text-red-600 text-xs px-2 py-1 rounded">Sold</span>
            @endif
        </div>
        <p class="text-2xl font-bold text-yellow-400 mb-2">${{ number_format($product->price, 2) }}</p>
        <p class="text-sm text-gray-500 mb-2">📍 {{ $product->location }}</p>
        <p class="text-sm text-gray-500 mb-4">👤 {{ $product->user->name }}</p>
        <a href="{{ route('products.show', $product) }}" class="block w-full bg-black text-white text-center py-2 rounded-lg hover:bg-gray-800 transition">
            View Details
        </a>
    </div>
</div>
