@extends('layouts.app')

@section('content')
<div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-8">
    <h1 class="text-3xl font-bold mb-8">Categories</h1>

    <div class="grid grid-cols-2 md:grid-cols-3 lg:grid-cols-4 gap-6">
        @foreach($categories as $category)
            <a href="{{ route('categories.show', $category) }}" 
               class="bg-white p-6 rounded-lg shadow-md hover:shadow-lg transition text-center border border-gray-200">
                <div class="text-4xl mb-3">
                    @switch($category->name)
                        @case('Electronics')📱@break
                        @case('Books')📚@break
                        @case('Furniture')🪑@break
                        @case('Clothing')👕@break
                        @case('Sports')⚽@break
                        @case('Food')🍔@break
                        @case('Transportation')🚲@break
                        @case('Services')🔧@break
                        @default📦
                    @endswitch
                </div>
                <h3 class="font-semibold text-lg">{{ $category->name }}</h3>
                <p class="text-sm text-gray-500">{{ $category->products_count }} items</p>
            </a>
        @endforeach
    </div>
</div>
@endsection
