<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Laravel\Sanctum\HasApiTokens;

class User extends Authenticatable
{
    use HasApiTokens, HasFactory, Notifiable;

    protected $fillable = [
        'name',
        'email',
        'password',
        'campus',
        'department',
        'level',
        'avatar',
        'is_admin',
    ];

    protected $hidden = [
        'password',
        'remember_token',
    ];

    protected $casts = [
        'email_verified_at' => 'datetime',
        'password' => 'hashed',
        'is_admin' => 'boolean',
    ];

    public function products()
    {
        return $this->hasMany(Product::class);
    }

    public function sentMessages()
    {
        return $this->hasMany(Message::class, 'sender_id');
    }

    public function receivedMessages()
    {
        return $this->hasMany(Message::class, 'receiver_id');
    }

    public function conversations()
    {
        $sentConversations = $this->sentMessages()->with('product')->get()->groupBy('receiver_id');
        $receivedConversations = $this->receivedMessages()->with('product')->get()->groupBy('sender_id');
        
        return $sentConversations->merge($receivedConversations)->keys();
    }

    public function getUnreadMessagesCount()
    {
        return $this->receivedMessages()->whereNull('read_at')->count();
    }
}
