<?php

namespace App\Http\Controllers;

use App\Models\Category;
use App\Models\Product;
use Illuminate\Http\Request;

class HomeController extends Controller
{
    public function index()
    {
        $categories = Category::withCount('products')->get();
        $products = Product::with('user', 'category')
            ->where('status', 'active')
            ->latest()
            ->take(8)
            ->get();

        return view('welcome', compact('categories', 'products'));
    }
}
